/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.DeleteFilesDialog;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class CacheSettingsDialog
extends JDialog {
    private final int DIALOG_WIDTH_UNIX = 510;
    private final int DIALOG_WIDTH_WIN = 470;
    private final int VERTICAL_STRUT_UNIX = 12;
    private final int VERTICAL_STRUT_WIN = 6;
    private final int CACHE_MIN_SIZE = 1;
    private final int CACHE_MAX_SIZE = 32768;
    private JTextField location;
    private JLabel locLbl;
    private JLabel diskSpaceLbl;
    private JLabel compressionLbl;
    private JLabel unitsLbl;
    private JButton chooseBtn;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton deleteFilesBtn;
    private JButton restoreDefaultsBtn;
    private JComboBox compression;
    private JSlider cacheSizeSlider;
    private JSpinner cacheSizeSpinner;
    private JCheckBox cacheEnabled;
    private int dialogWidth = 510;
    private int verticalStrut = 12;

    public CacheSettingsDialog(Frame frame, boolean bl) {
        super(frame, bl);
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            this.dialogWidth = 470;
            this.verticalStrut = 6;
        }
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(this.getMessage("cache.settings.dialog.title"));
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 12));
        this.cacheEnabled = new JCheckBox(this.getMessage("cache.settings.dialog.cacheEnabled"));
        this.cacheEnabled.setMnemonic(ResourceManager.getVKCode("cache.settings.dialog.cacheEnabled.mnemonic"));
        this.cacheEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CacheSettingsDialog.this.checkboxStateChanged(itemEvent);
            }
        });
        jPanel.add(Box.createHorizontalStrut(12));
        jPanel.add(this.cacheEnabled);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 12, this.verticalStrut, 12), BorderFactory.createTitledBorder(this.getMessage("cache.settings.dialog.cache_location"))));
        this.locLbl = new JLabel(this.getMessage("cache.settings.dialog.location_label"));
        JPanel jPanel3 = new JPanel(new FlowLayout(3, 0, 5));
        jPanel3.add(Box.createHorizontalStrut(24));
        jPanel3.add(this.locLbl);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.location = new JTextField();
        this.location.setPreferredSize(new Dimension(10, this.location.getPreferredSize().height));
        this.chooseBtn = this.makeButton("cache.settings.dialog.change_btn");
        this.chooseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.chooseButtonActionPerformed(actionEvent);
            }
        });
        this.chooseBtn.setToolTipText(this.getMessage("cache.settings.dialog.change_btn.tooltip"));
        jPanel4.add(Box.createHorizontalStrut(24));
        jPanel4.add(this.location);
        jPanel4.add(Box.createHorizontalStrut(12));
        jPanel4.add(this.chooseBtn);
        jPanel4.add(Box.createHorizontalStrut(12));
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jPanel4, "Center");
        jPanel2.add(Box.createVerticalStrut(this.verticalStrut), "South");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 12, this.verticalStrut, 12), BorderFactory.createTitledBorder(this.getMessage("cache.settings.dialog.disk_space"))));
        this.compressionLbl = new JLabel(this.getMessage("cache.settings.dialog.compression"));
        String[] stringArray = new String[]{this.getMessage("cache.settings.dialog.none"), this.getMessage("cache.settings.dialog.low"), this.getMessage("cache.settings.dialog.medium"), this.getMessage("cache.settings.dialog.high")};
        this.compression = new JComboBox<String>(stringArray);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 0, this.verticalStrut, 0));
        jPanel6.add(Box.createHorizontalStrut(24));
        jPanel6.add(this.compressionLbl);
        jPanel6.add(Box.createHorizontalStrut(12));
        jPanel6.add(Box.createHorizontalGlue());
        jPanel6.add(this.compression);
        this.diskSpaceLbl = new JLabel(this.getMessage("cache.settings.dialog.diskSpaceLbl"));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 0, this.verticalStrut, 0));
        jPanel7.add(Box.createHorizontalStrut(24));
        jPanel7.add(this.diskSpaceLbl);
        jPanel7.add(Box.createHorizontalGlue());
        jPanel7.add(Box.createHorizontalStrut(12));
        this.cacheSizeSlider = new JSlider(1, 32768);
        this.cacheSizeSlider.setMinorTickSpacing(1638);
        this.cacheSizeSlider.setPaintTicks(true);
        this.cacheSizeSlider.setPaintLabels(false);
        this.cacheSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CacheSettingsDialog.this.sliderStateChanged(changeEvent);
            }
        });
        this.cacheSizeSpinner = new JSpinner(new SpinnerNumberModel(32768, 1, 32768, 1));
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.cacheSizeSpinner, "######");
        numberEditor.getTextField().setColumns(8);
        numberEditor.getTextField().setHorizontalAlignment(11);
        ((NumberFormatter)numberEditor.getTextField().getFormatter()).setCommitsOnValidEdit(true);
        ((NumberFormatter)numberEditor.getTextField().getFormatter()).setAllowsInvalid(false);
        this.cacheSizeSpinner.setEditor(numberEditor);
        this.cacheSizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CacheSettingsDialog.this.updateSlider();
            }
        });
        this.unitsLbl = new JLabel("MB");
        int n = this.unitsLbl.getPreferredSize().width + 12 + 12;
        jPanel6.add(Box.createHorizontalStrut(n));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(0, 0, this.verticalStrut, 0));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(4, 0, 5));
        jPanel9.add(this.cacheSizeSpinner);
        jPanel8.add(Box.createHorizontalStrut(24));
        jPanel8.add(this.cacheSizeSlider);
        jPanel8.add(Box.createHorizontalStrut(12));
        jPanel8.add(jPanel9);
        jPanel8.add(Box.createHorizontalStrut(12));
        jPanel8.add(this.unitsLbl);
        jPanel8.add(Box.createHorizontalStrut(12));
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)jPanel7, "Center");
        jPanel5.add((Component)jPanel8, "South");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout(4, 6, 5));
        jPanel10.setBorder(BorderFactory.createEmptyBorder(0, 12, this.verticalStrut, 12));
        this.deleteFilesBtn = this.makeButton("cache.settings.dialog.delete_btn");
        this.deleteFilesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.deleteFilesBtnActionPerformed(actionEvent);
            }
        });
        this.deleteFilesBtn.setToolTipText(this.getMessage("temp.files.delete.btn.tooltip"));
        this.restoreDefaultsBtn = this.makeButton("cache.settings.dialog.restore_btn");
        this.restoreDefaultsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.restoreDefaultsBtnActionPerformed(actionEvent);
            }
        });
        this.restoreDefaultsBtn.setToolTipText(this.getMessage("cache.settings.dialog.restore_btn.tooltip"));
        DialogTemplate.resizeButtons(new JButton[]{this.deleteFilesBtn, this.restoreDefaultsBtn});
        jPanel10.add(this.deleteFilesBtn);
        jPanel10.add(Box.createHorizontalGlue());
        jPanel10.add(Box.createHorizontalGlue());
        jPanel10.add(this.restoreDefaultsBtn);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add((Component)jPanel2, "North");
        jPanel11.add((Component)jPanel5, "Center");
        jPanel11.add((Component)jPanel10, "South");
        this.okBtn = new JButton(this.getMessage("common.ok_btn"));
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheSettingsDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        this.cancelBtn = new JButton(this.getMessage("common.cancel_btn"));
        this.cancelBtn.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        DialogTemplate.resizeButtons(new JButton[]{this.okBtn, this.cancelBtn});
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createEmptyBorder(this.verticalStrut, 12, this.verticalStrut, 12));
        jPanel12.setLayout(new FlowLayout(2, 0, 0));
        jPanel12.add(Box.createHorizontalGlue());
        jPanel12.add(this.okBtn);
        jPanel12.add(Box.createHorizontalStrut(6));
        jPanel12.add(this.cancelBtn);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout());
        JSeparator jSeparator = new JSeparator();
        jSeparator.setPreferredSize(new Dimension(this.dialogWidth, 1));
        jPanel13.add((Component)jSeparator, "North");
        jPanel13.add((Component)jPanel12, "Center");
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel11, "Center");
        this.getContentPane().add((Component)jPanel13, "South");
        this.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        this.setResizable(false);
        this.initValues();
    }

    public void initValues() {
        this.location.setText(Config.getCacheDirectory());
        this.location.setToolTipText(this.location.getText());
        this.location.setHorizontalAlignment(2);
        boolean bl = !Config.isLocked("deployment.user.cachedir") && !Config.getInstance().isPlatformWindowsVista();
        this.location.setEnabled(bl);
        this.location.setEditable(false);
        this.chooseBtn.setEnabled(bl);
        String string = Config.getProperty("deployment.cache.max.size").trim();
        bl = !Config.isLocked("deployment.cache.max.size");
        try {
            int n = Integer.valueOf(string);
            if (n == -1) {
                ((JSpinner.NumberEditor)this.cacheSizeSpinner.getEditor()).getTextField().setValue(32768);
                this.cacheSizeSlider.setValue(32768);
            } else {
                ((JSpinner.NumberEditor)this.cacheSizeSpinner.getEditor()).getTextField().setValue(n);
                this.cacheSizeSlider.setValue(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            int n = 32768;
            this.cacheSizeSpinner.setValue(n);
            this.cacheSizeSlider.setValue(n);
        }
        if (!bl) {
            this.cacheSizeSlider.setEnabled(bl);
            this.cacheSizeSpinner.setEnabled(bl);
        }
        bl = !Config.isLocked("deployment.cache.jarcompression");
        int n = Config.getIntProperty("deployment.cache.jarcompression");
        if (n / 3 < this.compression.getItemCount()) {
            this.compression.setSelectedIndex(n / 3);
        } else {
            this.compression.setSelectedIndex(0);
        }
        this.compression.setEnabled(bl);
        bl = !Config.isLocked("deployment.cache.enabled");
        boolean bl2 = Config.getBooleanProperty("deployment.cache.enabled");
        this.cacheEnabled.setSelected(bl2);
        this.cacheEnabled.setEnabled(bl);
        this.setAllEnabled(bl2);
    }

    private void restoreDefaultsBtnActionPerformed(ActionEvent actionEvent) {
        if (!Config.isLocked("deployment.user.cachedir")) {
            this.location.setText(Config.getDefaultCacheDirectory());
            this.location.setToolTipText(this.location.getText());
        }
        if (!Config.isLocked("deployment.cache.max.size")) {
            ((JSpinner.NumberEditor)this.cacheSizeSpinner.getEditor()).getTextField().setValue(32768);
            this.cacheSizeSlider.setValue(32768);
        }
        if (!Config.isLocked("deployment.cache.jarcompression")) {
            int n = 0;
            if (n / 3 < this.compression.getItemCount()) {
                this.compression.setSelectedIndex(n / 3);
            } else {
                this.compression.setSelectedIndex(0);
            }
        }
        if (!Config.isLocked("deployment.cache.enabled")) {
            this.cacheEnabled.setSelected(true);
            this.setAllEnabled(this.cacheEnabled.isSelected());
        }
    }

    private void chooseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(this.getMessage("cache.settings.dialog.chooser_title"));
        jFileChooser.setApproveButtonText(this.getMessage("cache.settings.dialog.select"));
        String string = this.getMessage("cache.settings.dialog.select_tooltip");
        jFileChooser.setApproveButtonToolTipText(string);
        char c = this.getMessage("cache.settings.dialog.select_mnemonic").charAt(0);
        jFileChooser.setApproveButtonMnemonic(c);
        File file = new File(this.location.getText());
        jFileChooser.setCurrentDirectory(file);
        if (jFileChooser.showDialog(this, null) == 0) {
            String string2;
            try {
                string2 = jFileChooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = jFileChooser.getSelectedFile().getPath();
            }
            if (new File(string2).isDirectory()) {
                this.location.setText(string2);
                this.location.setToolTipText(string2);
            } else {
                String string3 = this.getMessage("cache.settings.dialog.chooser_title");
                String string4 = this.getMessage("cache.settings.dialog.directory_masthead");
                String string5 = this.getMessage("cache.settings.dialog.directory_body");
                String string6 = ResourceManager.getString("common.ok_btn");
                UIFactory.showErrorDialog(this, new AppInfo(), string3, string4, string5, string6, null, null, null, null);
            }
        }
    }

    private void deleteFilesBtnActionPerformed(ActionEvent actionEvent) {
        new DeleteFilesDialog(this);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        Config.setCacheDirectory(this.location.getText());
        if (this.cacheSizeSlider.getValue() == 32768) {
            Config.setProperty("deployment.cache.max.size", "-1");
        } else {
            Config.setProperty("deployment.cache.max.size", String.valueOf(this.cacheSizeSlider.getValue()));
        }
        Config.setIntProperty("deployment.cache.jarcompression", this.compression.getSelectedIndex() * 3);
        Config.setBooleanProperty("deployment.cache.enabled", this.cacheEnabled.isSelected());
        this.setVisible(false);
        this.dispose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getVKCode(string + ".mnemonic"));
        return jButton;
    }

    private void sliderStateChanged(ChangeEvent changeEvent) {
        this.cacheSizeSpinner.setValue(this.cacheSizeSlider.getValue());
    }

    private void updateSlider() {
        this.cacheSizeSlider.setValue(Integer.valueOf(this.cacheSizeSpinner.getModel().getValue().toString()));
    }

    private void checkboxStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            this.setAllEnabled(false);
        }
        if (itemEvent.getStateChange() == 1) {
            this.setAllEnabled(true);
        }
    }

    private void setAllEnabled(boolean bl) {
        this.location.setEnabled(bl && !Config.isLocked("deployment.user.cachedir"));
        this.locLbl.setEnabled(bl && !Config.isLocked("deployment.user.cachedir"));
        this.chooseBtn.setEnabled(bl && !Config.isLocked("deployment.user.cachedir") && !Config.getInstance().isPlatformWindowsVista());
        this.compression.setEnabled(bl && !Config.isLocked("deployment.cache.jarcompression"));
        this.compressionLbl.setEnabled(bl && !Config.isLocked("deployment.cache.jarcompression"));
        this.diskSpaceLbl.setEnabled(bl && !Config.isLocked("deployment.cache.max.size"));
        this.cacheSizeSlider.setEnabled(bl && !Config.isLocked("deployment.cache.max.size"));
        this.cacheSizeSpinner.setEnabled(bl && !Config.isLocked("deployment.cache.max.size"));
        this.unitsLbl.setEnabled(bl && !Config.isLocked("deployment.cache.max.size"));
    }
}

